(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24750,        676]
NotebookOptionsPosition[     23138,        621]
NotebookOutlinePosition[     23899,        647]
CellTagsIndexPosition[     23856,        644]
WindowTitle->Illustrating the Central Limit Theorem with Sums of Uniform and \
Exponential Random Variables - Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Ilustracja Centralnego Twierdzenia Granicznego", "Section",
 CellFrameColor->RGBColor[
  0.6449835965514611, 0.758632791638056, 0.2516823071641108],
 CellChangeTimes->{{3.507896025239067*^9, 3.507896041325987*^9}},
 FontColor->RGBColor[
  0.6449835965514611, 0.758632791638056, 0.2516823071641108]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Switch", "[", 
    RowBox[{"d", ",", "\[IndentingNewLine]", "1", ",", "\[IndentingNewLine]", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PDF", "[", 
          RowBox[{"dn", ",", "z"}], "]"}], ",", 
         RowBox[{"fZ", "[", 
          RowBox[{"z", ",", "n"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", 
         RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Thickness", "[", "Medium", "]"}], ",", "Red"}], "}"}], 
          ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Thickness", "[", "Medium", "]"}], ",", "Blue"}], "}"}]}],
          "}"}]}], ",", 
       RowBox[{"PlotPoints", "\[Rule]", "25"}], ",", 
       RowBox[{"Exclusions", "\[Rule]", "None"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"1.02", "-", 
           RowBox[{"zm", " ", "0.61"}]}]}], "}"}]}], ",", 
       RowBox[{"Axes", "\[Rule]", "False"}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"MaxRecursion", "\[Rule]", "5"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"500", ",", "300"}], "}"}]}], ",", 
       RowBox[{"ImagePadding", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"20", ",", "10"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"20", ",", "10"}], "}"}]}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", "2", ",", "\[IndentingNewLine]", " ", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PDF", "[", 
          RowBox[{"dn", ",", "z"}], "]"}], ",", 
         RowBox[{"yy", "=", 
          RowBox[{
           RowBox[{"PDF", "[", 
            RowBox[{
             RowBox[{"GammaDistribution", "[", 
              RowBox[{"n", ",", "1"}], "]"}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"Sqrt", "[", "n", "]"}], "*", "z"}], "+", "n"}]}], 
            "]"}], 
           RowBox[{"Sqrt", "[", "n", "]"}]}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", 
         RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Thickness", "[", "Medium", "]"}], ",", "Red"}], "}"}], 
          ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Thickness", "[", "Medium", "]"}], ",", "Blue"}], "}"}]}],
          "}"}]}], ",", 
       RowBox[{"PlotPoints", "\[Rule]", "37"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"1.02", "-", 
           RowBox[{"zm", " ", "0.61"}]}]}], "}"}]}], ",", 
       RowBox[{"Axes", "\[Rule]", "False"}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"500", ",", "300"}], "}"}]}], ",", 
       RowBox[{"ImagePadding", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"20", ",", "10"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"20", ",", "10"}], "}"}]}], "}"}]}]}], "]"}]}], 
    "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "40", ",", "1", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"d", ",", "1", ",", "\"\<distribution\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
       "1", "\[Rule]", " ", "\"\<rozk\[LSlash]ad jednorodny(0,1)\>\""}], ",", 
       RowBox[{"2", "\[Rule]", "\"\<rozk\[LSlash]ad eksponencjalny\>\""}]}], 
      "}"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"zm", ",", " ", "0", ",", " ", "\"\<zoom\>\""}], "}"}], ",", 
     "0", ",", "1", ",", "0.2", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"TrackedSymbols", "\[RuleDelayed]", 
    RowBox[{"{", 
     RowBox[{"n", ",", "d", ",", "zm"}], "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"Initialization", "\[RuleDelayed]", 
    RowBox[{"(", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"fX", "[", 
        RowBox[{"z_", ",", " ", "n_"}], "]"}], ":=", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"-", "1"}], ")"}], "j"], 
          RowBox[{"Binomial", "[", 
           RowBox[{"n", ",", "j"}], "]"}], 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"z", "-", "j"}], ")"}], "^", 
             RowBox[{"(", 
              RowBox[{"n", "-", "1"}], ")"}]}], ")"}], "/", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"n", "-", "1"}], ")"}], "!"}]}]}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", "0", ",", 
           RowBox[{"Floor", "[", "z", "]"}]}], "}"}]}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"fZ", "[", 
        RowBox[{"z_", ",", "n_"}], "]"}], ":=", 
       RowBox[{"With", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"s", "=", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"n", "/", "12"}], "]"}]}], "}"}], ",", " ", 
         RowBox[{
          RowBox[{"fX", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"s", " ", "z"}], "+", 
             RowBox[{"n", "/", "2"}]}], ",", "n"}], "]"}], "s"}]}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"dn", "=", 
       RowBox[{"NormalDistribution", "[", 
        RowBox[{"0", ",", "1"}], "]"}]}], ";"}], ")"}]}]}], 
  "\[IndentingNewLine]", "]"}]], "Input",
 CellChangeTimes->{
  3.35696210375764*^9, 3.475161863622842*^9, {3.475162057963758*^9, 
   3.475162064426228*^9}, {3.475162127847261*^9, 3.475162199890706*^9}, {
   3.4751623881642857`*^9, 3.475162441394466*^9}, {3.475162472182742*^9, 
   3.4751624823230553`*^9}, {3.4751625250722303`*^9, 
   3.4751625697843027`*^9}, {3.475162656578006*^9, 3.475162664037424*^9}, {
   3.475162714201765*^9, 3.475162754048437*^9}, {3.475162788759121*^9, 
   3.4751628419315767`*^9}, {3.475163447101129*^9, 3.4751635558242903`*^9}, {
   3.475163588696306*^9, 3.475163623792955*^9}, {3.475163666637191*^9, 
   3.4751636814918118`*^9}, {3.47516372113733*^9, 3.4751637862707663`*^9}, {
   3.47516387833014*^9, 3.4751638814890203`*^9}, 3.47516405064804*^9, {
   3.4751641985221577`*^9, 3.475164202505128*^9}, {3.475164245576705*^9, 
   3.475164480460219*^9}, {3.475164532042102*^9, 3.47516465522641*^9}, {
   3.475164990662421*^9, 3.475165026623249*^9}, {3.4751651695879374`*^9, 
   3.475165174246786*^9}, {3.4751652052451773`*^9, 3.4751652334769897`*^9}, 
   3.475165300448833*^9, {3.4751653620334597`*^9, 3.475165421456697*^9}, 
   3.475165684387059*^9, {3.475165821746809*^9, 3.475165824451165*^9}, {
   3.475165856369213*^9, 3.475165861694254*^9}, {3.475166030382525*^9, 
   3.475166030685361*^9}, {3.4751666559683247`*^9, 3.475166661248645*^9}, {
   3.475166710395544*^9, 3.475166713520817*^9}, 3.475166796483925*^9, {
   3.475166845854286*^9, 3.475166897537999*^9}, {3.4751671326506643`*^9, 
   3.4751671342808657`*^9}, {3.47516738206735*^9, 3.475167393104354*^9}, {
   3.475167429445793*^9, 3.475167451538652*^9}, 3.475167483770886*^9, {
   3.4751675622610493`*^9, 3.47516764836845*^9}, {3.475167686235918*^9, 
   3.47516776458327*^9}, {3.4751678589755*^9, 3.475167874685154*^9}, {
   3.475173592130713*^9, 3.4751735962245197`*^9}, {3.4751792008719397`*^9, 
   3.4751792507901573`*^9}, {3.475179335080928*^9, 3.475179395661943*^9}, {
   3.4751794630609007`*^9, 3.4751796615558157`*^9}, {3.475180187164578*^9, 
   3.4751801900042458`*^9}, {3.47518023492519*^9, 3.4751802896862297`*^9}, {
   3.475180377550948*^9, 3.475180381456012*^9}, {3.4751804472106247`*^9, 
   3.475180449072206*^9}, {3.4751829301148357`*^9, 3.4751829325469303`*^9}, {
   3.475182963776354*^9, 3.475182965120118*^9}, {3.4751829966235456`*^9, 
   3.475183002076206*^9}, {3.4751830740162897`*^9, 3.4751830743904657`*^9}, {
   3.475322862846018*^9, 3.4753228953423176`*^9}, {3.4754376842286124`*^9, 
   3.4754376908536124`*^9}, 3.4754377261036124`*^9, {3.4754377661661124`*^9, 
   3.4754377895254874`*^9}, {3.475443305788172*^9, 3.475443326138163*^9}, {
   3.4754957191337633`*^9, 3.4754957769831457`*^9}, {3.4754960059327383`*^9, 
   3.475496012452471*^9}, {3.475496512016308*^9, 3.4754965128178387`*^9}, {
   3.475496741352265*^9, 3.475496742008884*^9}, 3.47549677346591*^9, {
   3.475499591180254*^9, 3.47549961429527*^9}, {3.475499884908533*^9, 
   3.475499900030971*^9}, {3.4754999628110027`*^9, 3.4754999643620987`*^9}, 
   3.475500000562049*^9, {3.4755000488309717`*^9, 3.475500057185986*^9}, {
   3.4759373963775454`*^9, 3.4759374202189293`*^9}, {3.507896158883711*^9, 
   3.507896169819336*^9}, {3.5078962032032456`*^9, 3.5078962148349113`*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`d$$ = 2, $CellContext`n$$ = 
    1, $CellContext`zm$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 1, 40, 1}, {{
       Hold[$CellContext`d$$], 1, "distribution"}, {
      1 -> "uniform(0,1)", 2 -> "unit exponential"}}, {{
       Hold[$CellContext`zm$$], 0, "zoom"}, 0, 1, 0.2}}, Typeset`size$$ = {
    500., {147., 153.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = False, $CellContext`n$32237$$ = 
    0, $CellContext`d$32238$$ = False, $CellContext`zm$32239$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`d$$ = 1, $CellContext`n$$ = 
        1, $CellContext`zm$$ = 0}, "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$32237$$, 0], 
        Hold[$CellContext`d$$, $CellContext`d$32238$$, False], 
        Hold[$CellContext`zm$$, $CellContext`zm$32239$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Switch[$CellContext`d$$, 1, 
        Plot[{
          PDF[$CellContext`dn, $CellContext`z], 
          $CellContext`fZ[$CellContext`z, $CellContext`n$$]}, \
{$CellContext`z, -4, 4}, PlotStyle -> {{
            Thickness[Medium], Red}, {
            Thickness[Medium], Blue}}, PlotPoints -> 25, Exclusions -> None, 
         PlotRange -> {0, 1.02 - $CellContext`zm$$ 0.61}, Axes -> False, 
         Frame -> True, MaxRecursion -> 5, ImageSize -> {500, 300}, 
         ImagePadding -> {{20, 10}, {20, 10}}], 2, 
        Plot[{
          PDF[$CellContext`dn, $CellContext`z], $CellContext`yy = PDF[
             GammaDistribution[$CellContext`n$$, 1], 
             Sqrt[$CellContext`n$$] $CellContext`z + $CellContext`n$$] 
           Sqrt[$CellContext`n$$]}, {$CellContext`z, -4, 4}, PlotStyle -> {{
            Thickness[Medium], Red}, {
            Thickness[Medium], Blue}}, PlotPoints -> 37, 
         PlotRange -> {0, 1.02 - $CellContext`zm$$ 0.61}, Axes -> False, 
         Frame -> True, ImageSize -> {500, 300}, 
         ImagePadding -> {{20, 10}, {20, 10}}]], 
      "Specifications" :> {{$CellContext`n$$, 1, 40, 1, Appearance -> 
         "Labeled"}, {{$CellContext`d$$, 1, "distribution"}, {
         1 -> "uniform(0,1)", 2 -> "unit exponential"}}, {{$CellContext`zm$$, 
          0, "zoom"}, 0, 1, 0.2, Appearance -> "Labeled"}}, 
      "Options" :> {
       TrackedSymbols :> {$CellContext`n$$, $CellContext`d$$, \
$CellContext`zm$$}}, "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{551., {218., 225.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>(($CellContext`fX[
         Pattern[$CellContext`z, 
          Blank[]], 
         Pattern[$CellContext`n, 
          Blank[]]] := 
       Sum[((-1)^$CellContext`j 
          Binomial[$CellContext`n, $CellContext`j]) (($CellContext`z - \
$CellContext`j)^($CellContext`n - 1)/
          Factorial[$CellContext`n - 1]), {$CellContext`j, 0, 
          Floor[$CellContext`z]}]; $CellContext`fZ[
         Pattern[$CellContext`z, 
          Blank[]], 
         Pattern[$CellContext`n, 
          Blank[]]] := 
       With[{$CellContext`s = 
          Sqrt[$CellContext`n/
            12]}, $CellContext`fX[$CellContext`s $CellContext`z + \
$CellContext`n/2, $CellContext`n] $CellContext`s]; $CellContext`dn = 
       NormalDistribution[0, 1]; Null); Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->158892923]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Caption", "Section",
 CellFrameColor->RGBColor[
  0.6449835965514611, 0.758632791638056, 0.2516823071641108],
 FontColor->RGBColor[
  0.6449835965514611, 0.758632791638056, 0.2516823071641108]],

Cell[TextData[{
 "The exact probability density function (PDF) of standardized sums of ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " uniform ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"0", ",", "1"}], ")"}], TraditionalForm]], "InlineMath"],
 " or unit exponential variables is compared with the standard normal \
density. As ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "\[Rule]", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 ", these PDFs converge to the standard normal PDF (central limit theorem).  "
}], "Text"],

Cell[TextData[{
 "For the uniform ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"0", ",", "1"}], ")"}], TraditionalForm]], "InlineMath"],
 " case, convergence occurs quickly. In the case of the exponential, \
convergence is less rapid."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Details", "Section",
 CellFrameColor->RGBColor[
  0.6449835965514611, 0.758632791638056, 0.2516823071641108],
 FontColor->RGBColor[
  0.6449835965514611, 0.758632791638056, 0.2516823071641108]],

Cell[TextData[{
 "[1, p. 64] shows that the cumulative distribution function for the sum ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["Y", "n"], TraditionalForm]], "InlineMath"],
 " of ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " independent uniform ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"0", ",", "1"}], ")"}], TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  FormBox[Cell["", "InlineMath"], TraditionalForm]]],
 "random variables, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["Y", "n"], "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["X", "1"], "+"}], "..."}], "+", 
     SubscriptBox["X", "n"]}]}], TraditionalForm]], "InlineMath"],
 ", is"
}], "Text"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"F", "(", "y", ")"}], "=", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"j", "=", "0"}], 
      RowBox[{"[", "y", "]"}]], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "j"], 
      RowBox[{"(", "\[NegativeThinSpace]", GridBox[{
         {"n"},
         {"j"}
        }], "\[NegativeThinSpace]", ")"}], 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"y", "-", "j"}], ")"}], "n"], 
       RowBox[{"n", "!"}]]}]}]}], TraditionalForm]], "InlineMath"],
 "."
}], "Text"],

Cell[TextData[{
 "Taking the derivative, we obtain the PDF of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["Y", "n"], TraditionalForm]], "InlineMath"],
 ". In the case of the unit exponential, the PDF of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["Y", "n"], TraditionalForm]], "InlineMath"],
 " is the gamma distribution with shape parameter ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Alpha]", "=", "n"}], TraditionalForm]], "InlineMath"],
 " and scale parameter ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Beta]", "=", "1"}], TraditionalForm]], "InlineMath"],
 ". In each case we compare the standard normal PDF with the PDF of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["Z", "n"], "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["Y", "n"], "-", 
       SubscriptBox["\[Mu]", "n"]}], ")"}], "/", 
     SubscriptBox["\[Sigma]", "n"]}]}], TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Mu]", "n"], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Sigma]", "n"], TraditionalForm]], "InlineMath"],
 " are the mean and standard deviation of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["Y", "n"], TraditionalForm]], "InlineMath"],
 ", respectively."
}], "Text"],

Cell[TextData[{
 "[1] N. L. Johnson and S. Kotz, ",
 StyleBox["Continuous Univariate Distributions, Vol. 2,",
  FontSlant->"Italic"],
 " Boston: Houghton Mifflin, 1970."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 1}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.691905, 0.790311, 0.300252],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.691905, 0.790311, 0.300252]],

Cell[TextData[{
 "\"",
 ButtonBox["Illustrating the Central Limit Theorem with Sums of Uniform and \
Exponential Random Variables",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
IllustratingTheCentralLimitTheoremWithSumsOfUniformAndExpone/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/\
IllustratingTheCentralLimitTheoremWithSumsOfUniformAndExpone/"],
 "\"",
 " from ",
 ButtonBox["The Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/\
IllustratingTheCentralLimitTheoremWithSumsOfUniformAndExpone/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
IllustratingTheCentralLimitTheoremWithSumsOfUniformAndExpone/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/\
IllustratingTheCentralLimitTheoremWithSumsOfUniformAndExpone/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]]
}, Open  ]],

Cell[CellGroupData[{

Cell[" ", "Text",
 CellFrame->{{0, 0}, {0, 1}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.691905, 0.790311, 0.300252],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.691905, 0.790311, 0.300252]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Ian McLeod",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Ian+McLeod"], 
    None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Ian+McLeod"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6]],

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system (Version 6 or higher) is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.865507, 0.90634, 0.680751],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[0.986023, 0.991363, 0.969818]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["The Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
IllustratingTheCentralLimitTheoremWithSumsOfUniformAndExpone"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{1584, 1065},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Illustrating the Central Limit Theorem with Sums of Uniform and \
Exponential Random Variables - Source",
DockedCells->{},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
CellContext->Notebook,
FrontEndVersion->"11.0 for Microsoft Windows (64-bit) (September 21, 2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[684, 24, 304, 5, 70, "Section"],
Cell[CellGroupData[{
Cell[1013, 33, 9358, 212, 348, "Input"],
Cell[10374, 247, 4093, 82, 460, "Output",
 CellID->158892923]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14516, 335, 199, 4, 70, "Section"],
Cell[14718, 341, 562, 15, 49, "Text"],
Cell[15283, 358, 260, 8, 30, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15580, 371, 199, 4, 70, "Section"],
Cell[15782, 377, 742, 27, 30, "Text"],
Cell[16527, 406, 630, 23, 48, "Text"],
Cell[17160, 431, 1283, 41, 49, "Text"],
Cell[18446, 474, 181, 5, 30, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18664, 484, 373, 9, 50, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[19040, 495, 1189, 32, 34, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20266, 532, 337, 9, 50, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[20606, 543, 427, 14, 18, "Text"],
Cell[21036, 559, 847, 24, 98, "Text"],
Cell[21886, 585, 1236, 33, 88, "Text"]
}, Open  ]]
}
]
*)

